import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/auto_payment/mobile_recharge_auto_payment_controller.dart';

import 'package:viserpay/data/repo/recharge/recharge_repo.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay/view/components/cash-card/balance_box_card.dart';
import 'package:viserpay/view/components/cash-card/user/user_card.dart';
import 'package:viserpay/view/components/cash-card/title_card.dart';
import 'package:viserpay/view/components/image/rechange_image_widget.dart';
import 'package:viserpay/view/components/snack_bar/show_custom_snackbar.dart';

class MobileRechargeAutoPaymentAmountScreen extends StatefulWidget {
  const MobileRechargeAutoPaymentAmountScreen({super.key});

  @override
  State<MobileRechargeAutoPaymentAmountScreen> createState() => _MobileRechargeAutoPaymentAmountScreenState();
}

class _MobileRechargeAutoPaymentAmountScreenState extends State<MobileRechargeAutoPaymentAmountScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(RechargeRepo(apiClient: Get.find()));
    final controller = Get.put(MobileRechargeAutoPaymentController(rechargeRepo: Get.find(), contactController: Get.find()));
    //
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.setSelectedAutoPayValue(1);
      if (controller.selectedMethod == -1) {
        Get.back();
      }
      if (controller.selectedMethod == 1) {
        controller.numberController.text = "";
      } else {
        controller.selectedContact = null;
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomAppBar(
        title: MyStrings.mobileRechargeAutoPayment.tr,
        isTitleCenter: true,
        elevation: 0.3,
      ),
      body: GetBuilder<MobileRechargeAutoPaymentController>(builder: (controller) {
        return SingleChildScrollView(
          physics: const BouncingScrollPhysics(),
          child: Padding(
            padding: Dimensions.defaultPaddingHV,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              // crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                TitleCard(
                  title: MyStrings.for_.tr,
                  onlyBottom: true,
                  widget: Padding(
                    padding: const EdgeInsets.all(10.0),
                    child: UserCard(
                      title: controller.selectedContact?.name.toString() ?? controller.selectedContact?.number.toString() ?? "",
                      subtitle: controller.selectedContact?.number.toString() ?? "",
                      rightWidget: RechargeImageWidget(
                        imageUrl: controller.selectedoperator?.getImage.toString() ?? "",
                        boxFit: BoxFit.contain,
                        height: 45,
                        width: 50,
                        radius: 0,
                      ),
                    ),
                  ),
                ),
                const SizedBox(
                  height: Dimensions.space16,
                ),
                TitleCard(
                  title: "${MyStrings.autoPayFrequency.tr} ",
                  onlyBottom: true,
                  widget: Column(
                    children: <Widget>[
                      RadioListTile<int>(
                        title: Text(
                          MyStrings.everyMonth.tr,
                          style: regularLarge,
                        ),
                        subtitle: controller.selectedAutoPayValue != 1
                            ? null
                            : GestureDetector(
                                onTap: () => controller.selectNextAuoPayDateDate(context, autoPayInitialDate: controller.selectedAutoPayDateTime), // Open date picker on tap
                                child: Row(
                                  children: [
                                    RichText(
                                      text: TextSpan(
                                        children: [
                                          TextSpan(
                                            text: "${MyStrings.nextAutoPaymentDate.tr} ",
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontExtraSmall,
                                            ),
                                          ),
                                          TextSpan(
                                            text: DateFormat('yyyy-MM-dd').format(controller.selectedAutoPayDateTime), // Display selected date
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontSmall,
                                              color: MyColor.redCancelTextColor, // Set date text color to red
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    SizedBox(width: 4), // Spacing between text and icon
                                    Icon(
                                      Icons.calendar_month,
                                      color: MyColor.redCancelTextColor,
                                      size: 16, // Icon size to match text
                                    ),
                                  ],
                                ),
                              ),
                        value: 1,
                        groupValue: controller.selectedAutoPayValue,
                        onChanged: (value) {
                          controller.setSelectedAutoPayValue(value ?? 1);
                        },
                      ),
                      RadioListTile<int>(
                        title: Text(
                          MyStrings.every15days.tr,
                          style: regularLarge,
                        ),
                        subtitle: controller.selectedAutoPayValue != 2
                            ? null
                            : GestureDetector(
                                onTap: () => controller.selectNextAuoPayDateDate(context, autoPayInitialDate: controller.selectedAutoPayDateTime), // Open date picker on tap
                                child: Row(
                                  children: [
                                    RichText(
                                      text: TextSpan(
                                        children: [
                                          TextSpan(
                                            text: "${MyStrings.nextAutoPaymentDate.tr} ",
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontExtraSmall,
                                            ),
                                          ),
                                          TextSpan(
                                            text: DateFormat('yyyy-MM-dd').format(controller.selectedAutoPayDateTime), // Display selected date
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontSmall,
                                              color: MyColor.redCancelTextColor, // Set date text color to red
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    SizedBox(width: 4), // Spacing between text and icon
                                    Icon(
                                      Icons.calendar_month,
                                      color: MyColor.redCancelTextColor,
                                      size: 16, // Icon size to match text
                                    ),
                                  ],
                                ),
                              ),
                        value: 2,
                        groupValue: controller.selectedAutoPayValue,
                        onChanged: (value) {
                          controller.setSelectedAutoPayValue(value ?? 2);
                        },
                      ),
                      RadioListTile<int>(
                        title: Text(
                          MyStrings.everyWeek.tr,
                          style: regularLarge,
                        ),
                        subtitle: controller.selectedAutoPayValue != 3
                            ? null
                            : GestureDetector(
                                onTap: () => controller.selectNextAuoPayDateDate(context, autoPayInitialDate: controller.selectedAutoPayDateTime), // Open date picker on tap
                                child: Row(
                                  children: [
                                    RichText(
                                      text: TextSpan(
                                        children: [
                                          TextSpan(
                                            text: "${MyStrings.nextAutoPaymentDate.tr} ",
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontExtraSmall,
                                            ),
                                          ),
                                          TextSpan(
                                            text: DateFormat('yyyy-MM-dd').format(controller.selectedAutoPayDateTime), // Display selected date
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontSmall,
                                              color: MyColor.redCancelTextColor, // Set date text color to red
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    SizedBox(width: 4), // Spacing between text and icon
                                    Icon(
                                      Icons.calendar_month,
                                      color: MyColor.redCancelTextColor,
                                      size: 16, // Icon size to match text
                                    ),
                                  ],
                                ),
                              ),
                        value: 3,
                        groupValue: controller.selectedAutoPayValue,
                        onChanged: (value) {
                          controller.setSelectedAutoPayValue(value ?? 3);
                        },
                      ),
                    ],
                  ),
                ),
                const SizedBox(
                  height: Dimensions.space16,
                ),
                BalanceBoxCard(
                  focusNode: controller.amountFocusNode,
                  textEditingController: controller.amountController,
                  onpress: () {
                    double currntBalance = NumberFormat.decimalPattern().parse(controller.currentBalance).toDouble();
                    if (controller.amountController.text.trim().isNotEmpty) {
                      if (MyUtils().balanceValidation(currentBalance: currntBalance, amount: double.tryParse(controller.amountController.text) ?? 0)) {
                        Get.toNamed(RouteHelper.rechargeAutoPaymentPinScreen);
                      }
                    } else {
                      CustomSnackBar.error(errorList: [MyStrings.enterAmount]);
                    }
                  },
                ),
                const SizedBox(height: Dimensions.space16),
              
                const SizedBox(height: Dimensions.space16),
              ],
            ),
          ),
        );
      }),
    );
  }
}
